% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Sensitivity analysis

% Set parameters to baseline values
PARMS.ALPHA     = 0.81; % Cobb-Douglas parameter for capital in revenue function
PARMS.rho_eps   = .9304807665; % AR(1) of eps
PARMS.sigma_eps = .4326043886; % sigma of eps
PARMS.F_upper   = .1689333554; % upper bound of adjustment cost distribution

% Obtain baseline moments
[~, ~, steady]  = steady_state(PARMS);
moms_ss         = steady.modelmoms;
h               = 1e-04;
res             = zeros(5,3);

% Vary the following parameters:
% BETA
PARMS.B         = PARMS.B + h;
[~, ~, steady]  = steady_state(PARMS);
PARMS.B         = PARMS.B - h;
moms_B          = steady.modelmoms;
res(1,:)        = (moms_B(1:3) - moms_ss(1:3)) / h;
% ALPHA
PARMS.ALPHA     = PARMS.ALPHA + h;
[~, ~, steady]  = steady_state(PARMS);
PARMS.ALPHA     = PARMS.ALPHA - h;
moms_A          = steady.modelmoms;
res(2,:)        = (moms_A(1:3) - moms_ss(1:3)) / h;
% SIGMA
sig             = PARMS.sigma_eps;
PARMS.sigma_eps = sig + h;
[~, ~, steady]  = steady_state(PARMS);
moms_sig        = steady.modelmoms;
res(3,:)        = (moms_sig(1:3) - moms_ss(1:3)) / h;
PARMS.sigma_eps = sig;
% F upper bound
F               = PARMS.F_upper;
PARMS.F_upper   = F + h;
[~, ~, steady]  = steady_state(PARMS);
moms_b          = steady.modelmoms;
res(4,:)        = (moms_b(1:3) - moms_ss(1:3)) / h;
PARMS.F_upper   = F;
% RHO_EPS
rho_eps         = PARMS.rho_eps;
PARMS.rho_eps   = rho_eps + h;
[~, ~, steady]  = steady_state(PARMS);
moms_rho        = steady.modelmoms;
res(5,:)        = (moms_rho(1:3) - moms_ss(1:3)) / h;
PARMS.rho_eps   = rho_eps;

%%
sensitivity     = res;

writematrix(sensitivity,sprintf('%s/TableD5.csv',PARMS.tabfolder))

clear res h moms*